%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FourierMotzkinGUI - A basic GUI for Fourier-Motzkin Elimination 
% with particular focus on applications to information theory
% Copyright (C) 2011  Joffrey Villard
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function FMGrunFME(hObject,eventData,panel)
% excution de l'algo de Fourier-Motzkin,
% rsultat dans les champs 'newA' et 'newM' de la structure 'data'
% puis affichage du rsultat
numSteps = getappdata(panel,'numSteps');
etape = numSteps.runFME;

data = FMGinitStep(panel,etape);
varsRemain = getappdata(panel,'varsRemain');

% on dsactive tous les menus
menus = getappdata(panel,'menus');
for k=1:length(menus)
	set(menus(k),'Enable','off');
end

%====================================================================
% panel pour marquer l'avancement
panelWait = uipanel('Parent',panel,...
	'Title','Fourier-Motzkin Elimination is running...',...
	'FontSize',14,...
	'BackgroundColor','white',...
	'Position',[.25 .05 .5 .95]);
runFME = 1;
setappdata(panelWait,'runFME',runFME);

% barre d'avancement
uicontrol(  panelWait,'Style','text',...
	'Units','normalized',...
	'BackgroundColor',[.9 .9 .9],...
	'Position',[0 .95 1 .04]);
rectWait = uicontrol(  panelWait,'Style','text',...
	'Units','normalized',...
	'BackgroundColor','red',...
	'Position',[0 .95 .001 .04]);

% texte de log
textWait = {'Initializing.'};
editWait = uicontrol(  panelWait,'Style','edit',...
	'FontName', 'FixedWidth',...
	'String', textWait,...
	'FontSize',12,...
	'HorizontalAlignment','left',...
	'Min',0, 'Max',2,...
	'Enable','inactive',...
	'Units','normalized',...
	'BackgroundColor','white',...
	'Position',[0 0 1 .94]);

%====================================================================
btGrp = uibuttongroup('Parent',panel,...
	'Units','normalized',...
	'Position',[0 0 1 .05]);

btStopStart = uicontrol(  btGrp,'Style','pushbutton',...
	'String','Cancel',...
	'FontSize',11,...
	'Units','normalized',...
	'Position',[.375 0 .25 1],...
	'Callback',@stopFME);
 drawnow;

%====================================================================
% on initialise le nouveau systme avec le premier,
% en ayant rordonn les variables et la matrice A
% ie, les variables  conserver sont  la fin

newData = struct('vars',{{}},'param',{{}},'A',{[]},'M',{[]});
newData.vars	= [data.vars(~varsRemain) data.vars(varsRemain)];
newData.A		= [data.A(:,~varsRemain) data.A(:,varsRemain)];
newData.param	= data.param;
newData.M		= data.M;

% nombre de variables
n = length(newData.vars);

% nombre de paramtres
p = length(newData.param);

% pour indiquer si des variables n'ont pas pu tre supprimes
varNOK = '';


%====================================================================
% un premier nettoyage
majWait('Reducing inequalities.',0,1);
[newData.A,newData.M] = FMGreduire(newData.A,newData.M,panelWait);

% itration sur toutes les variables  supprimer
nbIter = n-sum(varsRemain);
for k=1:nbIter
	if ~runFME,	break; end;
	
	majWait(sprintf('Eliminating variable %s.',newData.vars{1}),1,1);
		
	% nombre de variables restantes
	n = length(newData.vars);
	
	% matrice contenant [A M]
	temp = [newData.A newData.M];
	
	lpos = (temp(:,1)>0);		% lignes  1er coefficient positif
	lneg = (temp(:,1)<0);		% lignes  1er coefficient ngatif
	lzer = (temp(:,1)==0);		% lignes  1er coefficient nul

	npos = sum(lpos);		% nombre de 'positifs'
	nneg = sum(lneg);		% nombre de 'ngatifs'
	nzer = sum(lzer);		% nombre de 'zros'
	
	
	%----------------------------------------------------------------
	% SI la variable (actuellement en tte de la liste) ne peut pas tre limine
	if (npos==0 || nneg==0)
		% on l'indique pour un warning  la fin de l'limination
		if isempty(varNOK)
			varNOK = newData.vars{1};
		else
			varNOK = sprintf('%s, %s',varNOK,newData.vars{1});
		end
		
		% on la met  la fin et on continue l'algo
		newData.vars	= newData.vars([2:n, 1]);
		newData.A		= newData.A(:,[2:n, 1]);
		
		
	%----------------------------------------------------------------
	% SINON, limination de la variable !
	else
		% reduction de la liste de variables
		newData.vars = newData.vars(2:n);

		% on normalise les lignes de 'positifs' et 'ngatifs'
		temp((lpos|lneg),:) = temp((lpos|lneg),:) ./ abs( newData.A((lpos|lneg),1)*ones(1,n+p) );

		% on rorganise la matrice dans l'ordre 'positifs', 'ngatifs', 'zros'
		temp = [temp(lpos,:) ; temp(lneg,:) ; temp(lzer,:)];

		% nouveau systme avec (npos*nneg + nzer) lignes et (n-1)+p colonnes
		new = zeros( npos*nneg + nzer , n-1+p );

		% parcours des 'positifs'
		for i = 1:npos
			% on fait la somme avec chaque 'ngatif'
			new((i-1)*nneg+1:i*nneg,:)...
				= ones(nneg,1)*temp(i,2:end) + temp(npos+1:npos+nneg,2:end);
		end

		% on rajoute les 'zros'
		new(npos*nneg+1:npos*nneg+nzer,:) = temp(npos+nneg+1:end,2:end);

		% il reste (n-1) variables
		newData.A = new(:,1:n-1);
		newData.M = new(:,n:end);
				
		% nettoyage
		if ~runFME, break; end;
		majWait('Reducing inequalities.',0,1);
		[newData.A,newData.M] = FMGreduire(newData.A,newData.M,panelWait);
	end
end


%====================================================================
% SI l'limination a termin correctement, 
% sauvegarde de ces nouvelles donnes
if runFME
	setappdata(panel,'newData',newData);

	if ~isempty(varNOK)
		uiwait(msgbox(sprintf('Variable(s) %s can not be eliminated.',varNOK),'Warning','warn','modal'));
	end
	
	% on affiche le rsultat
	FMGresultat([],[],panel);

%====================================================================
% SINON, on propose de redmarrer
else
	majWait('Cancelled.',2,0);
	set(btStopStart,'Enable','on');
	set(btStopStart,'String','Restart FME');
	set(btStopStart,'Callback',{@FMGrunFME,panel});	
	FMGmajMenus([],[],panel,0);
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% bouton 'Cancel': on annule l'limination en cours (une seule fois !)
	function stopFME(ho,ev)
		if runFME
			runFME = 0;
			setappdata(panelWait,'runFME',runFME);
		end
	end

%----------------------------------------------------------------
% gestion de la barre d'avancement et du log texte
% - affichage du nombre d'ingalits
% - ajout de la chaine 'str'  la suite des messages
% - avancement de la barre	. d'un incrment si avancer=1
% -							. jusqu' la fin si avancer=2
	function majWait(str,avancer,affIneg)
		% on affiche le nombre d'ingalits
		if affIneg
			textWait{end+1} = sprintf('%d inequalities.',size(newData.A,1));
		end
		% on ajoute le message  la suite
		textWait{end+1} = str;
		set(editWait,'String',textWait);
		
		% on change la position de la barre, si avancer>0
		pos = get(rectWait,'Position');
		if (avancer==1)
			set(rectWait,'Position',pos+[0 0 1/(nbIter+1) 0]);
		elseif (avancer==2)			
			pos(3) = 1;
			set(rectWait,'Position',pos);
			set(rectWait,'BackgroundColor','black');
		end
		drawnow;
	end

end
