%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FourierMotzkinGUI - A basic GUI for Fourier-Motzkin Elimination 
% with particular focus on applications to information theory
% Copyright (C) 2011  Joffrey Villard
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function FMGresultat(hObject,eventData,panel)
% affichage du rsultat: systme intial et systme rduit
numSteps = getappdata(panel,'numSteps');
etape = numSteps.resultat;

data = FMGinitStep(panel,etape);

%====================================================================
% ancien systme
textOld = FMGafficher(data);

panelOld = uipanel('Parent',panel,...
	'Title','Initial list of inequalities',...
	'FontSize',14,...
	'BackgroundColor','white',...
	'Position',[0 .525 1 .475]);

uicontrol(  panelOld,'Style','edit',...
	'FontName', 'FixedWidth',...
	'String', textOld,...
	'FontSize',12,...
	'HorizontalAlignment','left',...
	'Min',0, 'Max',2,...
	'Enable','inactive',...
	'Units','normalized',...
	'BackgroundColor','white',...
	'Position',[0 0 1 1]);


%====================================================================
% nouveau systme ie, rduit
textNew = FMGafficher(getappdata(panel,'newData'));

panelNew = uipanel('Parent',panel,...
	'Title','Reduced list of inequalities',...
	'FontSize',14,...
	'BackgroundColor','white',...
	'Position',[0 .05 1 .475]);

uicontrol(  panelNew,'Style','edit',...
	'FontName', 'FixedWidth',...
	'String', textNew,...
	'FontSize',12,...
	'HorizontalAlignment','left',...
	'Min',0, 'Max',2,...
	'Enable','inactive',...
	'Units','normalized',...
	'BackgroundColor','white',...
	'Position',[0 0 1 1]);


%====================================================================
btGrp = uibuttongroup('Parent',panel,...
	'Units','normalized',...
	'Position',[0 0 1 .05]);

uicontrol(  btGrp,'Style','pushbutton',...
	'String','Export as text',...
	'FontSize',11,...
	'Units','normalized',...
	'Position',[.375 0 .25 1],...
	'Callback',@saveText);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function saveText(ho,ev)
		% on propose d'utiliser le nom de la session comme description 
		% et comme nom de fichier
		nomSession = getappdata(panel,'nomSession');
		[pathstr, nom] = fileparts(nomSession);
		
		description = inputdlg('Enter a description of the system.','',5,{nom},'on');
		[filename,pathname,filterindex] =...
			uiputfile('*.txt','Save systems as',fullfile(pathstr,nom));
		
		if (filterindex>0)
			fid = fopen(fullfile(pathname,filename),'wt');
			
			% description
			if ~isempty(description)
				description = description{1};
				for k=1:size(description,1)
					fprintf(fid,'%s\n',description(k,:));
				end				
			end
			
			% systme initial
			fprintf(fid,'\n==================== Initial System ====================\n\n');
			for k=1:length(textOld)
				fprintf(fid,'%s\n',textOld{k});
			end
			
			% systme rduit, aprs FME
			fprintf(fid,'\n==================== Reduced System ====================\n\n');
			for k=1:length(textNew)
				fprintf(fid,'%s\n',textNew{k});
			end
			
			fclose(fid);
		end
	end

end
