%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FourierMotzkinGUI - A basic GUI for Fourier-Motzkin Elimination 
% with particular focus on applications to information theory
% Copyright (C) 2011  Joffrey Villard
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [A,M] = FMGreduire(A,M,panelWait)
% suppression des lignes redondantes/inutiles, 
% en supposant que les PARAMETRES sont POSITIFS
% - 'panelWait' est le panel de log, qui contient en APPdata la variable
% runFME indiquant s'il faut poursuivre l'limination (ou si au contraire
% l'utilisateur a annul)

%====================================================================
[m,n] = size(A);
[m,p] = size(M);
np = n+p;

tab = [A M];
tab = FMGnormaliser(tab,n,p);

% 'niveau' indique  quel point pousser la rduction, on supprime une ligne SI
% 0. elle est 0<=(+)
% 1. il y a une ligne avec mme membre de gauche et membre de droite infrieur
% 2. elle est CLP des lignes impliquant une variable commune et des 0<=(?)
% 3. son membre de gauche est CLP des autres et le membre de droite
% correspondant est redondant 
niveau = 2;


%====================================================================
numLaLigne = 1;
while (numLaLigne < m)	
	% l'utilisateur a-t-il stopp l'limination ?
	drawnow; if ~getappdata(panelWait,'runFME'), return; end;
	
	% la ligne en cours
	laLigne = tab(numLaLigne,:);
		
	%====================================================================
	% autres lignes (entires, membres de gauche et droite) 
	reste = tab([1:numLaLigne-1 numLaLigne+1:m],:);
	
	% indices des autres lignes impliquant une des variables de laLigne
	auMoinsUneMemeVariable =...
		any( (reste(:,1:n)~=0) & (ones(m-1,1)*laLigne(1:n)~=0) ,2);
	
	% indices des lignes 0<=(?)
	gchZero = all( reste(:,1:n) == 0 ,2);
	
	% indices des autres lignes de mme membre de gauche
	gchEq = all( reste(:,1:n) == ones(m-1,1)*laLigne(1:n) ,2);
	
	% indices des autres lignes de membre de droite <= laLigne
	dteLeq = all( reste(:,n+1:np) <= (ones(m-1,1)*laLigne(n+1:np)) ,2);
		
	%====================================================================
	% on supprime la ligne SI
	
	%-------------------------------------------------------------------
	% 0. elle est 0<=(+)
	suppr = all(laLigne(1:n)==0) & all(laLigne(n+1:np)>=0);

	%-------------------------------------------------------------------
	% 1. il y a une ligne avec mme membre de gauche et membre de droite
	% infrieur
	if (niveau>=1)&&(~suppr)
		suppr = any( gchEq & dteLeq );
	end
	
	%-------------------------------------------------------------------
	% 2. elle est CLP des lignes impliquant une variable commune et des 0<=(?)
	if (niveau>=2)&&(~suppr)	
		test = reste(auMoinsUneMemeVariable | gchZero,:);
		suppr = (~isempty(FMGestCLP(laLigne,test,0,panelWait)));

	%-------------------------------------------------------------------
	% 3. son membre de gauche est CLP des autres et le membre de droite
	% correspondant est redondant ie, il y a au moins une de ces CLP qui donne
	% un membre de gauche infrieur
	elseif (niveau>=3)&&(~suppr)
		test = reste(auMoinsUneMemeVariable,:);
		coeff = FMGestCLP(laLigne(1:n),test(:,1:n),1,panelWait);
		suppr =  any( all( coeff*test(:,n+1:np) <= laLigne(n+1:np)*ones(size(coeff,1),1) , 2));
	end

	
	%====================================================================
	% SI suppression de la ligne
	if (suppr)
		tab = reste;
		m = size(tab,1);

	% SINON
	else
		numLaLigne = numLaLigne+1;
	end
end

A = tab(:,1:n);
M = tab(:,n+1:np);
