%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FourierMotzkinGUI - A basic GUI for Fourier-Motzkin Elimination 
% with particular focus on applications to information theory
% Copyright (C) 2011  Joffrey Villard
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function tab = FMGnormaliser(tab,n,p)
% normalisation du tableau reprsentant le systme d'ingalits

%================================================================
% SI tous les coefficients sont entiers 8 bits, on ne normalise pas

%================================================================
% SINON, normalisation des lignes pour que max(variables)=1
if ~all(int8(tab)==tab)
	% lignes avec au moins 1 coeff de variables non nul
	lnonnul = any(abs(tab(:,1:n)),2);

	% on normalise
	if any(lnonnul)
		tab(lnonnul,:) = tab(lnonnul,:) ./ (max(abs( tab(lnonnul,1:n) ),[],2)*ones(1,n+p));
	end

	%------------------------------------------------------------
	% SI pas de variables, normalisation des lignes pour que max(coeff)=1

	% lignes sans variable, avec au moins 1 coeff de paramtre non nul
	lnonnul = all( abs(tab(:,1:n))==0 ,2) & any( abs(tab(:,n+1:p))>0 ,2);

	% on normalise
	if any(lnonnul)
		tab(lnonnul,:) = tab(lnonnul,:) ./ (max(abs( tab(lnonnul,n+1:p) ),[],2)*ones(1,n+p));
	end

end
