%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FourierMotzkinGUI - A basic GUI for Fourier-Motzkin Elimination 
% with particular focus on applications to information theory
% Copyright (C) 2011  Joffrey Villard
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function FMGmajMenus(hObject,eventData,panel,k)
% mise  jour des donnes dans le panel et des menus
% si k>0, les donnes ont t modifies  l'tape k
% => il faut invalider les tapes suivantes

steps = getappdata(panel,'steps');

% invalidation des tapes suivantes
% + suppression des anciens rsultats
if (k>0)
	steps(k+1:end)=0;
	newData = struct('vars',{{}},'param',{{}},'A',{[]},'M',{[]});
		
	% maj des donnes
	setappdata(panel,'newData',newData);
	setappdata(panel,'steps',steps);
	setappdata(panel,'varsRemain',[]);
	
	% ajout de '*' dans le nom de la fentre pour indiquer 
	% qu'une modification a t effectue mais pas encore sauvegarde
	fenetre = get(panel,'Parent');
	nom = get(fenetre,'Name');
	if ~strcmp(nom(end),'*')
		set(fenetre,'Name',strcat(nom,'*'));
	end
end


% activation ou non des menus
menus = getappdata(panel,'menus');

% menus 'Save' et 'Start'
offset = 2;
set(menus(1),'Enable','on');
set(menus(2),'Enable','on');

for k=1:(length(menus)-offset)
	if steps(k)
		set(menus(k+offset),'Enable','on');
	else
		set(menus(k+offset),'Enable','off');
	end
end

