%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FourierMotzkinGUI - A basic GUI for Fourier-Motzkin Elimination 
% with particular focus on applications to information theory
% Copyright (C) 2011  Joffrey Villard
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function FMGinegalites(hObject,eventData,panel)
% entre des ingalits
numSteps = getappdata(panel,'numSteps');
etape = numSteps.inegalites;

data = FMGinitStep(panel,etape);

n = length(data.vars);
p = length(data.param);

% ensemble des champs d'entre de coefficients
coeffVars = cell(1,n);
coeffParam = cell(1,p);

% numro de l'ingalit en cours d'dition (le cas chant), sinon 0
indiceEdit = 0;

%====================================================================
panelDlg = uipanel('Parent',panel,...
	'Title','Enter an inequality: ',...
	'FontSize',14,...
	'BackgroundColor','white',...
	'Position',[0 .75 1 .25]);

% largeur d'un champ pour l'entre d'un coefficient
lgCoeff = .04;

% largeur d'un caractre pour l'affichage des variables et paramtres
lgChar = .0105;
htChar = .1;

% ligne du membre de gauche
yGch = .77;
% ligne du membre de droite
yDte = .44;

% pour aligner correctement les 'edit' et les 'text'
dyCoeff = -.05;

%--------------------------------------------------------------------
% membre de gauche
gauche = .02;
yLigne = yGch;
for k=1:n	
	coeffVars{k} = affMembre(0);
end

% focus sur le premier coeff du membre de gauche
uicontrol(coeffVars{1});

%--------------------------------------------------------------------
% signe <=
gauche = .03;
uicontrol(	panelDlg,'Style','text',...
	'String','_',...
	'FontSize',18,...
	'HorizontalAlignment','left',...
	'Units','normalized',...
	'BackgroundColor','white',...
	'Position',[gauche   .36   lgCoeff .25]);
uicontrol(	panelDlg,'Style','text',...
	'String','<',...
	'FontSize',18,...
	'HorizontalAlignment','left',...
	'Units','normalized',...
	'BackgroundColor','white',...
	'Position',[gauche   .44   lgCoeff .15]);
gauche = gauche + lgCoeff;

%--------------------------------------------------------------------
% membre de droite
yLigne = yDte;
for k=1:p
	coeffParam{k} = affMembre(1);
end


%====================================================================
btGrpHaut = uibuttongroup('Parent',panel,...
	'Units','normalized',...
	'Position',[0 .7 1 .05]);

% bouton 'OK' pour enregistrer cette ingalit et entrer la suivante
uicontrol(  btGrpHaut,'Style','pushbutton',...
	'String','OK',...
	'FontSize',11,...
	'Units','normalized',...
	'Position',[.425 0 .15 1],...
	'Callback',@inegOK);


%====================================================================
panelIneg = uipanel('Parent',panel,...
	'Title','List of inequalities',...
	'FontSize',14,...
	'BackgroundColor','white',...
	'Position',[0 .05 1 .65]);

listIneq = uicontrol(  panelIneg,'Style','listbox',...
	'FontName', 'FixedWidth',...
	'FontSize',12,...
	'HorizontalAlignment','left',...
	'Value',1,...
	'Units','normalized',...
	'BackgroundColor','white',...
	'Position',[0 0 1 1]);


%====================================================================
btGrpBas = uibuttongroup('Parent',panel,...
	'Units','normalized',...
	'Position',[0 0 1 .05]);

btEdit = uicontrol(  btGrpBas,'Style','pushbutton',...
	'String','Edit selected',...
	'FontSize',11,...
	'Units','normalized',...
	'Position',[.01 0 .15 1],...
	'Enable','off',...
	'Callback',@editSel);

btDelete = uicontrol(  btGrpBas,'Style','pushbutton',...
	'String','Delete selected',...
	'FontSize',11,...
	'Units','normalized',...
	'Position',[.17 0 .15 1],...
	'Enable','off',...
	'Callback',@deleteSel);

btClear = uicontrol(  btGrpBas,'Style','pushbutton',...
	'String','Clear all',...
	'FontSize',11,...
	'Units','normalized',...
	'Position',[.33 0 .15 1],...
	'Enable','off',...
	'Callback',@clearList);


btSuite = uicontrol(  btGrpBas,'Style','pushbutton',...
	'String','Choose remaining variables',...
	'FontSize',11,...
	'Units','normalized',...
	'Position',[.74 0 .25 1],...
	'Enable','off',...
	'Callback',{@FMGchoixVars,panel});

majListe;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% affichage d'un terme de l'ingalit (de nom 'val')  la position 'gauche'
% 'mbDte' indique si ce terme est du membre de droite
	function leChamp = affMembre(mbDte)

		% nom de la variable/du paramtre
		if mbDte
			nom = sprintf('*%s',data.param{k});
		else
			nom = sprintf('*%s',data.vars{k});
		end
		lgNom = length(nom)*lgChar;

		% si ce terme (du membre de droite) ne rentre pas sur la ligne,
		% on passe  la 2me ligne
		if mbDte && ((gauche + 2*lgChar + lgCoeff + lgNom)>1)
			yLigne = 2*yDte - yGch;
			gauche = .04+lgCoeff;
		end

		% signe '+'
		if(k>1)
			uicontrol( panelDlg,'Style','text',...
				'String','+',...
				'FontName', 'FixedWidth',...
				'FontUnits','normalized',...
				'FontSize',1,...
				'Units','normalized',...
				'BackgroundColor','white',...
				'Position',[gauche   yLigne   2*lgChar htChar]);
			gauche = gauche + 2*lgChar;
		end

		% champ d'entre du coefficient
		leChamp = uicontrol( panelDlg,'Style','edit',...
			'FontName', 'FixedWidth',...
			'FontUnits','normalized',...
			'FontSize',.5,...
			'Units','normalized',...
			'Position',[gauche   (yLigne+dyCoeff)   lgCoeff .2]);
		gauche = gauche + lgCoeff;

		% impression du nom de la variable/du paramtre
		uicontrol( panelDlg,'Style','text',...
			'String',nom,...
			'FontName', 'FixedWidth',...
			'FontUnits','normalized',...
			'FontSize',1,...
			'HorizontalAlignment','left',...
			'Units','normalized',...
			'BackgroundColor','white',...
			'Position',[gauche   yLigne   lgNom htChar]);
		gauche = gauche + lgNom;
	end


%----------------------------------------------------------------
% mise  jour de la liste des ingalits
	function majListe
		% mise  jour du contenu
		set(listIneq,'String',FMGafficher(data));
		
		% gestion des boutons
		if ~isempty(data.A)
			set(btEdit,'Enable','on');
			set(btDelete,'Enable','on');
			set(btClear,'Enable','on');
			set(btSuite,'Enable','on');
		else
			set(btEdit,'Enable','off');
			set(btDelete,'Enable','off');
			set(btClear,'Enable','off');
			set(btSuite,'Enable','off');
		end
		
		% SI une ligne est en cours d'dition
		if (indiceEdit>0)
			% elle reste slectionne
			set(listIneq,'Enable','inactive');
			set(listIneq,'Value',indiceEdit);
		else
			set(listIneq,'Enable','on');
		end
		
		% focus sur le premier champ d'entre
		uicontrol(coeffVars{1});
	end

%----------------------------------------------------------------
% bouton 'OK': sauvegarde de l'ingalit et attente de la suivante
	function inegOK(ho,ev)
		try
			[newLineA,newLineM] = getIneq;

			if (all(newLineA==0) && all(newLineM==0))
				uiwait(msgbox('Inequality "0<=0" is useless.','Warning','warn','modal'));

			else
				% si c'est une dition
				if (indiceEdit>0)
					data.A(indiceEdit,:) = newLineA;
					data.M(indiceEdit,:) = newLineM;
					indiceEdit=0;
					
				% si c'est une nouvelle ingalit
				else
					data.A = [data.A ; newLineA];
					data.M = [data.M ; newLineM];
				end

				setappdata(panel,'data',data);
				FMGmajMenus([],[],panel,etape);
				
				effacerChamps;
				majListe;
			end

		catch
			uiwait(msgbox(lasterr,'Error','error','modal'));
			uicontrol(coeffVars{1});
		end
	end


%----------------------------------------------------------------
% bouton 'Edit selected': modification de l'ingalit slectionne
	function editSel(ho,ev)
		indiceEdit = get(listIneq,'Value');
		
		% affichage de cette ingalit
		for j=1:n
			set(coeffVars{j},'String',data.A(indiceEdit,j));
		end
		for j=1:p
			set(coeffParam{j},'String',data.M(indiceEdit,j));
		end
				
		% il y a modif !
		FMGmajMenus([],[],panel,etape);
		
		majListe;
	end


%----------------------------------------------------------------
% bouton 'Delete selected': suppression de l'ingalit slectionne
	function deleteSel(ho,ev)
		reponse = questdlg('Delete selected inequality?','Warning','Yes','No','No');
		
		if strcmp(reponse,'Yes')
			% suppression de l'ingalit (ligne des matrices A et M)
			indice = get(listIneq,'Value');
			data.A(indice,:) = [];
			data.M(indice,:) = [];
			
			% sauvegarde des donnes
			setappdata(panel,'data',data);
			
			% gestion des menus (on a modifi qqch  cette tape)
			FMGmajMenus([],[],panel,etape);
			
			% SI on tait en 'Edit', c'est cette ingalit qu'on a supprim,
			% SINON, 'indiceEdit' tait dj nul
			indiceEdit=0;
			
			% mise  jour de la liste des ingalits
			set(listIneq,'Value',1);
			majListe;
		end			
	end


%----------------------------------------------------------------
% bouton 'Clear all': suppression de toutes les ingalits
	function clearList(ho,ev)
		reponse = questdlg('Clear ALL inequalities?','Warning','Yes','No','No');
		
		if strcmp(reponse,'Yes')
			% suppresion de toutes les ingalits 
			data.A = [];
			data.M = [];
									
			% sauvegarde des donnes
			setappdata(panel,'data',data);
			
			% gestion des menus (on a modifi qqch  cette tape)
			FMGmajMenus([],[],panel,etape);
						
			% toutes les ingalits ont t supprimes
			% -> il n'y a pas (plus) d'dition en cours
			indiceEdit=0;
			
			% mise  jour de la liste des ingalits
			set(listIneq,'Value',1);
			majListe;
		end
		
	end


%----------------------------------------------------------------
% rcupration de l'ingalit entre par l'utilisateur
	function [newLineA,newLineM] = getIneq
		newLineA = zeros(1,n);
		for j=1:n
			str = get(coeffVars{j},'String');
			[nb status] = str2num(str);
			if status
				newLineA(j) = nb;
			elseif ~isempty(str)
				error('"%s" is not allowed as a coefficient',str);
			end
		end
		
		newLineM = zeros(1,p);
		for j=1:p
			str = get(coeffParam{j},'String');
			[nb status] = str2num(str);
			if status
				newLineM(j) = nb;
			elseif ~isempty(str)
				error('"%s" is not allowed as a coefficient',str);
			end					
		end
	end


%----------------------------------------------------------------
% effacement de tous les champs d'entre
	function effacerChamps
		for j=1:n
			set(coeffVars{j},'String','');
		end
		for j=1:p
			set(coeffParam{j},'String','');
		end
	end

end
