%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FourierMotzkinGUI - A basic GUI for Fourier-Motzkin Elimination 
% with particular focus on applications to information theory
% Copyright (C) 2011  Joffrey Villard
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function coeff = FMGestCLP(uneLigne,A,toutes,panelWait)
% - 'coeff', matrice (?,n+p), contient les coefficients
% de toutes les possibilits de uneLigne = coeff * A, avec coeff >= 0
% ie, toutes les Combinaisons Linaires  coefficients Positifs
% de LIGNES de la matrice A
% - si 'toutes'=0, on s'arrte  la premire CLP rencontre !

% taille de la famille A (nombre de lignes)
m = size(A,1);

% initialisation
coeff = [];

% on parcourt l'ensemble des combinaisons de lignes de A en utilisant la
% reprsentation binaire sur m bits de l'ensemble 1:2^(m-1)
base2=2.^(m-1:-1:0);

for k=1:(2^m-1)
	% l'utilisateur a-t-il stopp l'limination ?
	drawnow; if ~getappdata(panelWait,'runFME'), return; end;
	
	% lignes  slectionner (toutes celles correspondant  un bit = 1)
	idxSel = (bitget(k*base2,m) > 0);
	lignesSel = A(idxSel,:);
	
	%================================================================
	% SI les lignes slectionnes sont linairement dpendantes
	% on saute cette combinaison, cf. si jamais v est CL de ces lignes,
	% on le retrouvera pour une combinaison avec moins d'lments

	%================================================================
	% SINON
	if (rank(lignesSel) == size(lignesSel,1))
		% SI v est linairement dpendant des lignes slectionnes
		if (rank(lignesSel) == rank([lignesSel ; uneLigne]))
			
			%--------------------------------------------------------
			% les coefficients de la combinaison linaire
			c = zeros(1,m);
			c(idxSel) = uneLigne*pinv(lignesSel);

			%--------------------------------------------------------
			% sont-ils tous positifs ?
			if all(c>=0)				
				% SI cette combinaison n'a jamais t retenue, on la garde
				if ~ismember(c,coeff,'rows')
					coeff(end+1,:) = c;
				end
				
				% SI on ne veut pas toutes les CLP, stop !
				if (~toutes), break; end;
			end
		end
	end
end
