%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FourierMotzkinGUI - A basic GUI for Fourier-Motzkin Elimination 
% with particular focus on applications to information theory
% Copyright (C) 2011  Joffrey Villard
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function FMGentreeVarsParam(hObject,eventData,panel,etape)
% entre des variables et paramtres
%
% 'etape':
% 2 -> entre des variables
% 3 -> entre des paramtres
numSteps = getappdata(panel,'numSteps');
etapeVars  = numSteps.entreeVars;
etapeParam = numSteps.entreeParam;
etapeIneg  = numSteps.inegalites;

data = FMGinitStep(panel,etape);

% numro de la variable/le paramtre en cours d'dition (le cas chant), sinon 0
indiceEdit = 0;

%====================================================================
% panel du haut pour l'entre des variables/paramtres
panelDlg = uipanel('Parent',panel,...
    'FontSize',14,...
    'BackgroundColor','white',...
    'Position',[0 .85 1 .15]);
if (etape==etapeVars)
	set(panelDlg,'Title','Enter the name of a variable: ');	
else
	set(panelDlg,'Title','Enter the name of a (non-negative) parameter: ');
end

% champ de texte pour l'entre du nom
nomEntree = uicontrol( panelDlg,'Style','edit',...
	'FontName', 'FixedWidth',...
    'FontSize',13,...
    'Units','normalized',...
    'Position',[.05 .25 .9 .5]);
uicontrol(nomEntree);


%====================================================================
btGrpHaut = uibuttongroup('Parent',panel,...
	'Units','normalized',...
	'Position',[0 .8 1 .05]);

% bouton 'OK' pour enregistrer cette variable/ce paramtre 
% et entrer le(la) suivant(e)
uicontrol(  btGrpHaut,'Style','pushbutton',...
	'String','OK',...
	'TooltipString','Save the current name and enter the next one.',...
	'FontSize',11,...
	'Units','normalized',...
	'Position',[.425 0 .15 1],...
	'Callback',@ok);

%====================================================================
% liste des variables enregistres
panelVars = uipanel('Parent',panel,...
    'Title','List of variables',...
    'FontSize',14,...
    'BackgroundColor','white',...
    'Position',[0 .05 .5 .75]);

listVars = uicontrol(  panelVars,'Style','listbox',...
	'FontName', 'FixedWidth',...
    'FontSize',12,...
	'HorizontalAlignment','center',...
    'Units','normalized',...
    'BackgroundColor','white',...
    'Position',[0 0 1 1]);
if (etape==etapeVars)
    set(listVars,'Enable','on');	
else
	set(listVars,'Enable','off');
end


%====================================================================
% liste des paramtres enregistrs
panelParam = uipanel('Parent',panel,...
    'Title','List of parameters',...
    'FontSize',14,...
    'BackgroundColor','white',...
    'Position',[.5 .05 .5 .75]);

listParam = uicontrol(  panelParam,'Style','listbox',...
	'FontName', 'FixedWidth',...
    'FontSize',12,...
	'HorizontalAlignment','center',...
    'Units','normalized',...
    'BackgroundColor','white',...
    'Position',[0 0 1 1]);
if (etape==etapeVars)
	set(listParam,'Enable','off');
else
	set(listParam,'Enable','on');
end


%====================================================================
btGrpBas = uibuttongroup('Parent',panel,...
	'Units','normalized',...
	'Position',[0 0 1 .05]);

btEdit = uicontrol(  btGrpBas,'Style','pushbutton',...
	'String','Edit selected',...
	'FontSize',11,...
	'Units','normalized',...
	'Position',[.01 0 .15 1],...
	'Enable','off',...
	'Callback',@editSel);

btDelete = uicontrol(  btGrpBas,'Style','pushbutton',...
	'String','Delete selected',...
	'FontSize',11,...
	'Units','normalized',...
	'Position',[.17 0 .15 1],...
	'Enable','off',...
	'Callback',@deleteSel);

btClear = uicontrol(  btGrpBas,'Style','pushbutton',...
	'String','Clear all',...
	'FontSize',11,...
	'Units','normalized',...
	'Position',[.33 0 .15 1],...
	'Enable','off',...
	'Callback',@clearList);


% bouton 'Enter parameters' ou 'Enter inequalities' 
% pour terminer l'entre des variables/des paramres
btSuite = uicontrol(  btGrpBas,'Style','pushbutton',...
	'FontSize',11,...
	'Units','normalized',...
	'Position',[.74 0 .25 1],...
	'Enable','off',...
	'Callback',@nextStep);
if (etape==etapeVars)
	set(btSuite,...
		'TooltipString','Save the current list of variables and enter the name of the parameters.',...
		'String','Enter parameters');
else
	set(btSuite,...
		'TooltipString','Save the current list of parameters and enter the inequalities.',...
		'String','Enter inequalities');
end

majListe;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% mise  jour de la liste de variables ou de paramtres
	function majListe
		% mise  jour du contenu
		set(listVars,'String',data.vars);
		% mise  jour du contenu
		set(listParam,'String',data.param);

		% taille de la liste en cours de modification
		if (etape==etapeVars)
			m = length(data.vars);
		else
			m = length(data.param);
		end
		
		% gestion des boutons
		if (m>0)
			set(btEdit,'Enable','on');
			set(btDelete,'Enable','on');
			set(btClear,'Enable','on');
			set(btSuite,'Enable','on');
		else
			set(btEdit,'Enable','off');
			set(btDelete,'Enable','off');
			set(btClear,'Enable','off');	
			set(btSuite,'Enable','off');		
		end
		
		% SI une variable/un paramtre est en cours d'dition
		if (indiceEdit>0)
			% elle reste slectionne
			if (etape==etapeVars)
				set(listVars,'Enable','inactive');
				set(listVars,'Value',indiceEdit);
			else
				set(listParam,'Enable','inactive');
				set(listParam,'Value',indiceEdit);
			end
		else
			if (etape==etapeVars)
				set(listVars,'Enable','on');
			else
				set(listParam,'Enable','on');
			end
		end
		
		% focus sur le champ d'entre
		uicontrol(nomEntree);
    end


%----------------------------------------------------------------
% bouton 'OK': sauvegarde de l'entre et attente de la suivante
    function ok(ho,ev)
        nom = get(nomEntree,'String');
		if isempty(nom)
			uiwait(msgbox('Empty string is not allowed.','Error','error','modal'));

		else			
			% SI c'est une dition
			if (indiceEdit>0)
				if (etape==etapeVars)
					data.vars{indiceEdit} = nom;
				else
					data.param{indiceEdit} = nom;
				end
				indiceEdit=0;

			% SI c'est une nouvelle entre
			else
				if (etape==etapeVars)
					% ajout de la variable
					data.vars{end+1} = nom;
					% ajout d'une colonne dans la bonne matrice si besoin
					if ~isempty(data.A)
						data.A = [data.A,  zeros(size(data.A,1),1)];
					end
				else
					% ajout du paramtre
					data.param{end+1} = nom;
					% ajout d'une colonne dans la bonne matrice si besoin
					if ~isempty(data.M)
						data.M = [data.M,  zeros(size(data.M,1),1)];
					end
				end
			end
			
			setappdata(panel,'data',data);
			FMGmajMenus([],[],panel,etapeIneg);
			set(nomEntree,'String','');
		end
		majListe;
	end


%----------------------------------------------------------------
% bouton 'Edit selected': modification de l'entre slectionne
	function editSel(ho,ev)
		% affichage de l'entre slectionne
		if (etape==etapeVars)
			indiceEdit = get(listVars,'Value');
			set(nomEntree,'String',data.vars{indiceEdit});
		else
			indiceEdit = get(listParam,'Value');
			set(nomEntree,'String',data.param{indiceEdit});
		end		
				
		% il y a modif d'une variable/un paramtre
		% Nok  partir des ingalits
		FMGmajMenus([],[],panel,etapeIneg);
		
		majListe;
	end


%----------------------------------------------------------------
% bouton 'Delete selected': suppression de l'entre slectionne
	function deleteSel(ho,ev)
		reponse = questdlg('Delete selected entry?','Warning','Yes','No','No');
		
		if strcmp(reponse,'Yes')
			if (etape==etapeVars)
				% suppression de la variable
				indice = get(listVars,'Value');
				data.vars = data.vars([1:indice-1, indice+1:end]);
				% suppression de la colonne dans la bonne matrice si besoin
				if ~isempty(data.A)
					data.A = data.A(:,[1:indice-1 , indice+1:end]);
				end
				set(listVars,'Value',1);
			else
				% suppression du paramtre
				indice = get(listParam,'Value');
				data.param = data.param([1:indice-1, indice+1:end]);
				% suppression de la colonne dans la bonne matrice si besoin
				if ~isempty(data.M)
					data.M = data.M(:,[1:indice-1 , indice+1:end]);
				end
				set(listParam,'Value',1);
			end
					
			% sauvegarde des donnes
			setappdata(panel,'data',data);
			
			% gestion des menus (on a modifi qqch  cette tape)
			FMGmajMenus([],[],panel,etapeIneg);
			
			% SI on tait en 'Edit', c'est cette variable/ce paramtre
			% qu'on a supprim
			% SINON, 'indiceEdit' tait dj nul
			indiceEdit=0;
			
			% mise  jour de la liste des variables/des paramtres
			majListe;
		end	
	end


%----------------------------------------------------------------
% bouton 'Clear all': suppression de toutes les entres
	function clearList(ho,ev)
		if (etape==etapeVars)
			entrees = 'variables';
		else
			entrees = 'parameters';
		end
		reponse = questdlg(sprintf('Clear ALL %s?',entrees),'Warning','Yes','No','No');
		
		if strcmp(reponse,'Yes')
			if (etape==etapeVars)
				% suppression de toutes les variables
				data.vars = {};
				set(listVars,'Value',1);
			else
				% suppression de tous les paramtres
				data.param = {};
				set(listParam,'Value',1);
			end
						
			% il y a eu suppression d'une variable/un paramtre
			% on rinitialise les ingalits
			data.A = [];
			data.M = [];
			
			% sauvegarde des donnes
			setappdata(panel,'data',data);
			
			% gestion des menus (on a modifi qqch  cette tape)			
			FMGmajMenus([],[],panel,etapeIneg);
						
			% toutes les ingalits ont t supprimes
			% -> il n'y a pas (plus) d'dition en cours
			indiceEdit=0;
			
			% mise  jour de la liste des variables/des paramtres
			majListe;
		end
	end


%----------------------------------------------------------------
% bouton 'Enter parameters' -> 'FMGentreeVarsParam([],[],panel,2)'
%	ou	 'Enter inequalities' -> 'FMGinegalites'
    function nextStep(ho,ev)		
		% si entre des variables en cours
        if (etape==etapeVars)
			if isempty(data.vars)
				uiwait(msgbox('Empty list of variables.','Error','error','modal'));
				uicontrol(nomEntree);
			else
				% entre des paramtres
				FMGentreeVarsParam([],[],panel,etapeParam);
			end
		% sinon, entre des paramtres en cours
		else			
			if isempty(data.param)
				uiwait(msgbox('Empty list of parameters.','Error','error','modal'));
				uicontrol(nomEntree);
			else
				% entre des ingalits
				FMGinegalites([],[],panel);
			end
        end
    end
		
end
