%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FourierMotzkinGUI - A basic GUI for Fourier-Motzkin Elimination 
% with particular focus on applications to information theory
% Copyright (C) 2011  Joffrey Villard
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function FMGchoixVars(hObject,eventData,panel)
% choix des variables  conserver
numSteps = getappdata(panel,'numSteps');
etape = numSteps.choixVars;

data = FMGinitStep(panel,etape);
n = length(data.vars);

% le rsultat est-il dj connu ?
steps = getappdata(panel,'steps');
resOK = steps(numSteps.resultat);

% variables  conserver
varsRemain = getappdata(panel,'varsRemain');

if isempty(varsRemain)
	varsRemain = zeros(1,n);
end

checkVars = cell(1,n);

%====================================================================
panelChoix = uipanel('Parent',panel,...
	'Title','Choose the remaining variables',...
	'FontSize',14,...
	'BackgroundColor','white',...
	'Position',[.25 .05 .5 .95]);

for k=1:n
	checkVars{k} = uicontrol(  panelChoix,'Style','checkbox',...
		'Value',varsRemain(k),...
		'FontName', 'FixedWidth',...
		'FontSize',12,...
		'String',data.vars{k},...
		'HorizontalAlignment','left',...
		'Units','normalized',...
		'BackgroundColor','white',...
		'Position',[.1 (1-k*.06) .8 .05],...
		'Callback',@modifVars);
end

%====================================================================
btGrp = uibuttongroup('Parent',panel,...
	'Units','normalized',...
	'Position',[0 0 1 .05]);

btOK = uicontrol(  btGrp,'Style','pushbutton',...
	'String','Run Fourier-Motzkin',...
	'FontSize',11,...
	'Units','normalized',...
	'Position',[.375 0 .25 1],...
	'Callback',@ok);
if resOK
	set(btOK,'Enable','off');
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% si une variable a t coche/dcoche, on invalide le rsultat, si celui
% existe dj 
	function modifVars(ho,ev)
		FMGmajMenus([],[],panel,etape);
		set(btOK,'Enable','on');
	end

%----------------------------------------------------------------
% bouton 'OK': rcupration des variables  conserver, excution de FME
	function ok(ho,ev)		
		% rcupration de la rponse de l'utilisateur
		for j=1:n
			varsRemain(j) = get(checkVars{j},'Value');
		end
		
		% SI aucune variable n'a t slectionne
		if all(varsRemain==0)
			uiwait(msgbox('At least one variable must be selected.','Error','error','modal'));
			
		else
			% on enregistre les variables  conserver
			setappdata(panel,'varsRemain',logical(varsRemain));
			
			FMGrunFME([],[],panel)
		end
	end

end
