%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FourierMotzkinGUI - A basic GUI for Fourier-Motzkin Elimination 
% with particular focus on applications to information theory
% Copyright (C) 2011  Joffrey Villard
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function total = FMGafficher(data)
% liste de chaines de caractres pour afficher un systme d'ingalits 
%  partir de la structure 'data' contenant
% les variables 'vars', les paramtres 'param', en cell arrays, 
% et des matrices A(m,n), M(m,p)

[m,n] = size(data.A);
p = length(data.param);

% si la matrice est vide, on veut m=0 (et pas m=1 !)
m = m*(~isempty(data.A));

% liste de chaines de caractres
% - membres de gauche
% - membres de droite
total  = cell(1,m);
gauche = cell(1,m);
droite = cell(1,m);

% longueur max d'un membre de gauche
lgMax = 0;

% parcours des lignes
for k=1:m
	%----------------------------------------------------------------
	% parcours des variables -> membre de gauche
	chaine = '';
	for j=1:n
		if (data.A(k,j)~=0)
			if(data.A(k,j)>0)
				if ~strcmp(chaine,'')
					chaine = sprintf('%s +',chaine);
				end
			elseif(data.A(k,j)<0)
				chaine = sprintf('%s -',chaine);
			end
			% rq :on n'crit pas les 1
			if (abs(data.A(k,j))~=1)
				chaine = sprintf('%s %.2f*',chaine,abs(data.A(k,j)));
			end
			chaine = sprintf('%s %s',chaine,data.vars{j});
		end
	end

	% si rien d'autre, on crit '0'
	if strcmp(chaine,'')
		chaine = '0';
	end

	gauche{k} = chaine;
	lgMax = max([lgMax length(chaine)]);
	
	%----------------------------------------------------------------
	% parcours des paramtres -> membre de droite
	chaine = '';
	for j=1:p
		if (data.M(k,j)~=0)
			if(data.M(k,j)>0)
				if ~strcmp(chaine,'')
					chaine = sprintf('%s +',chaine);
				end
			elseif(data.M(k,j)<0)
				chaine = sprintf('%s -',chaine);
			end
			% rq: on n'crit pas les 1
			if (abs(data.M(k,j))~=1)
				chaine = sprintf('%s %.2f*',chaine,abs(data.M(k,j)));
			end
			chaine = sprintf('%s %s',chaine,data.param{j});
		end
	end

	% si rien d'autre, on crit '0'
	if strcmp(chaine,'')
		chaine = '0';
	end

	droite{k} = chaine;
end

%----------------------------------------------------------------
% mise en forme finale

for k=1:m
	total{k} = sprintf('%s%s <= %s\n',blanks(lgMax-length(gauche{k})),gauche{k},droite{k});
end
	