%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FourierMotzkinGUI - A basic GUI for Fourier-Motzkin Elimination 
% with particular focus on applications to information theory
% Copyright (C) 2011  Joffrey Villard
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function FMGabout(hObject,eventData,panel)
% affichage du text ci-dessus + lien vers le fichier COPYING

set(findall(panel,'Style','pushbutton'),'Visible','off');

% nouvel panel pour cet affichage
panelAbout = uipanel('Parent',panel,...
	'BackgroundColor',[1 1 1],...
	'Units','normalized',...
	'Position',[.2 .15 .6 .7]);

% le texte en question
texte = {...
	' FourierMotzkinGUI - A basic GUI for Fourier-Motzkin Elimination',...
	' with particular focus on applications to information theory',...
	' Copyright (C) 2011  Joffrey Villard',...
	' ',...
	' This program is free software: you can redistribute it and/or modify',...
	' it under the terms of the GNU General Public License as published by',...
	' the Free Software Foundation, either version 3 of the License, or',...
	' (at your option) any later version.',...
	' ',...
	' This program is distributed in the hope that it will be useful,',...
	' but WITHOUT ANY WARRANTY; without even the implied warranty of',...
	' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.',...
	' See the GNU General Public License for more details.',...
	' ',...
	' You should have received a copy of the GNU General Public License',...
	' along with this program.  If not, see <http://www.gnu.org/licenses/>.',...
	' '};
uicontrol(panelAbout,'Style','text',...
	'String',texte,...
	'FontSize',12,...
	'ForegroundColor',[0 0 0],...
	'BackgroundColor',[1 1 1],...
	'HorizontalAlignment','left',...
	'Units','normalized',...
	'Position',[0 .1 1 .9]);

% bouton pour accder au fichier COPYING
uicontrol(panelAbout,'Style','pushbutton',...
	'String','COPYING',...
	'FontSize',12,...
	'Units','normalized',...
	'Position',[0 0 .2 .1],...
	'Callback','open(''COPYING'')');

% image GPLv3			
axesGPL = axes('Parent',panelAbout,...
	'GridLineStyle','none',...
	'Units','normalized',...
	'Position',[.4 0 .2 .1]);
image(imread('gplv3.png'),'Parent',axesGPL);
axis(axesGPL,'off')
axis(axesGPL,'image')

% bouton pour retourner  l'cran initial
uicontrol(panelAbout,'Style','pushbutton',...
	'String','Back',...
	'FontSize',12,...
	'Units','normalized',...
	'Position',[.8 0 .2 .1],...
	'Callback',@aboutBack);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% retour  l'cran initial
	function aboutBack(ho,ev)
		delete(panelAbout);
		set(get(panel,'Children'),'Visible','on');
	end


end
